#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Day 29 - Dwarf TrainMod01.fsh by   jeyko 
//https://www.shadertoy.com/view/3tG3RK
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define mx (200.*iMouse.x/iResolution.x)
#define dmin(a, b) a.x < b.x ? a : b
#define dmax(a, b) a.x > b.x ? a : b 
#define pmod(p, x) mod(p, x) - x*0.5
// start buffer

#define c0 texture0 
#define c1 texture1 
#define c2 texture2 
#define c3 texture3 

#define T(c, uv) texture2D(c, uv)

#define rot(x) mat2(cos(x),-sin(x),sin(x),cos(x))

#define pi acos(-1.)
#define tau (2.*pi)

// thx to iq
float sdCapsule( vec3 p, vec3 a, vec3 b, float r )
{
  vec3 pa = p - a, ba = b - a;
  float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
  return length( pa - ba*h ) - r;
}
float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

// Tri-Planar blending function. Based on an old Nvidia writeup:
// GPU Gems 3 - Ryan Geiss: https://developer.nvidia.com/gpugems/GPUGems3/gpugems3_ch01.html
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){
   
    n = max((abs(n) - .2)*7., .001);
    n /= (n.x + n.y + n.z );  
    
	p = (texture2D(tex, p.yz)*n.x + texture2D(tex, p.zx)*n.y + texture2D(tex, p.xy)*n.z).xyz;
    
    return p*p;
}

//end  buffer//

float r11c(float x){return texture2D(texture0, vec2(x, x*12.5)).x;}

vec2 offsetTunnel(float z){
    vec2 t = vec2(
        sin(z*0.1)*2.,
        cos(z*0.1)*2.
    );
    t.y -= 0.;
	return t;
}

#define szTunnel 1.

#define szLamp 0.08
#define lenLamp 0.24
vec2 sdLamp(vec3 p){
	vec2 d = vec2(sdCapsule( p, vec3(0,0,lenLamp), vec3(0.0), szLamp ), 2.); 
    
    return d;
} 

#define modDist 10.

vec3 centerPipes = vec3(0);
vec3 centerTunnel = vec3(0);


vec2 map(vec3 p){
	vec2 d = vec2(10e7);

    p.xy -= offsetTunnel(p.z);
    
    // --- TUNN --- //
    
    centerTunnel = p;
    d = dmin(d, vec2(-(length(p.xy) - szTunnel), 0.));
    
    
    
    vec3 q = p;
    q.x = abs(q.x);
    q.y = abs(q.y);
    //p.y -= szTunnel;
    
    q.xy -= vec2(cos(0.5),sin(0.5))*szTunnel;
    
    
    
    
    // --- PIPES --- //
    
    centerPipes = q;
    d = dmin(d, vec2((length(q.xy) - 0.1), 1.));
    
    q.z = pmod(q.z,1.);
    d = dmin(d, vec2(max((length(q.xy) - 0.12), -abs(q.z) + 0.3 ), 1.));
	
    
    // --- LAMP --- //
    float id = floor(p.z/modDist);
    p.z = pmod(p.z, modDist);
    q = p;
    q.y -= szTunnel*1.;
    q.z += lenLamp*1.;
    //q.z -= 1.;
    //d = dmin(d, sdLamp(q));
    d = dmin(d, vec2(sdCapsule( q, vec3(0,0,lenLamp), vec3(0.0), szLamp ), 2.));
    //q.y += 0.9;
    q.z -= szLamp*3.;
    
    float z = q.z;
    
    q.z = pmod(q.z, 0.14); 
    
    q.y -= smoothstep(0., 0.8, pow(length(z*0.29)*4.5, 3.)); // function drawing
    q.yz *= rot(0.5*pi);

    // lamp thingie
    d = dmin(d, vec2(0.61*sdTorus(q, vec2(0.10,0.015)), 4.));
    // --- FLOOR --- //
    float offsFloor = szTunnel*0.76;
    p.y += offsFloor;
    d = dmin(d, vec2(p.y , 0.));
    
    // --- TRAIN --- //
    float offsTrain = szTunnel*0.25;
    q = p;
    p.x = abs(p.x);
    p.x -= offsTrain*1.3;
    
    p.y -= 0.1;
    vec3 i = abs(p);
    i -= 0.01;
    float sm = length(max(i.y,0.0)) + min(max(i.x,max(i.y,i.z)),0.1) - 0.1;
    //d = dmin(d, vec2(sm, 5.));
    d = dmin(d, vec2(max(abs(p.y) - 0.04, abs(p.x) - 0.04), 5.));
    
    q.z = pmod(q.z, 0.5);
    q.y += 0.05;
	d = dmin(d, vec2(max(abs(q.y) - 0.1, max(abs(q.z) - 0.1, abs(q.x) - 0.54)) , 4.));
    
    
    d.x *= 0.9;
	return d;
}
vec3 pLamp;

float calcSoftshadow( in vec3 ro, in vec3 rd, in float mint, in float tmax, int technique )
{
    technique = 1;
	float res = 1.0;
    float t = mint;
    float ph = 1e10; // big, such that y = 0 on the first iteration
    
    for( int i=0; i<212; i++ )
    {
        vec2 d = map( ro + rd*t );
        
        //d.x -= texture(texture3, vec2(float(i))).x*0.002;
		float h = d.x;
		//h *=  0.7*exp(-h*2.);
        //h *= 1. - exp(-h*0.01)*0.6;
        //h *= 0.3 + exp(-length((ro.y + rd.y*t) - abs(pLamp.y))*20.)*0.7; // TODO: fix this so it's faster
        
        
        if (d.y == 2. ) {
            h += 0.3;
        }
        
        // traditional technique
        if( technique==0 )
        {
        	res = min( res, 10.0*h/t );
        }
        // improved technique
        else
        {
            // use this if you are getting artifact on the first iteration, or unroll the
            // first iteration out of the loop
            //float y = (i==0) ? 0.0 : h*h/(2.0*ph); 
            float y = h*h/(2.0*ph);
            float di = sqrt(h*h-y*y);
            res = min( res, 10.*di/max(0.,t-y) );
            ph = h;
        

        }
        
        t += h;
        
        if( res<0.005 || t>tmax ) break;
          
    }
    //res *= 5.4;
    return clamp( res, .0, 1.0 );
}



vec3 getNormal(vec3 p){
	vec2 t = vec2(0.0005, 0.);
    return normalize(
    	map(p).x - vec3(
        	map(p - t.xyy).x,
        	map(p - t.yxy).x,
        	map(p - t.yyx).x
        )
    );
}

vec3 getRd(vec3 ro, vec3 lookAt, vec2 uv){
	vec3 dir = normalize(lookAt - ro);
	vec3 right = normalize(cross(vec3(0,1,0), dir));
	vec3 up = normalize(cross(dir, right));
	return dir + right*uv.x + up*uv.y;
}

vec3 colLight = vec3(0.6,0.34,0.22)*2.2;

vec3 glow = vec3(0);
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - 0.5*iResolution.xy)/iResolution.y;

    vec3 col = vec3(0);
    vec3 ro = vec3(0,0,-0.);
    ro.z += iTime*5. + mx;
    ro.xy += offsetTunnel(ro.z);
    
    vec3 lookAt = ro + vec3(0,0,9);
    lookAt.xy += offsetTunnel(lookAt.z);
    
    vec3 rd = getRd(ro, lookAt, uv);
    vec3 p = ro; float t = 0.;vec2 d; vec3 l = vec3(0); bool didHit = false; float att = 0.;
    for(int i = 0; i < 270; i++){
    	d = map(p);
        if (d.y == 2.  ){
        	glow += exp(-d.x*4.);
        }
        
        if(d.x < 0.001){
            didHit = true;
            float id = floor(p.z/modDist);
            pLamp = vec3(0,szTunnel*1.,id*modDist + modDist*0.5 );
            pLamp.xy += offsetTunnel(pLamp.z);
            //pLamp.y += 0.001;
            att = 1.5/(length(p-pLamp),length(p-pLamp));
            
           
			vec3 n = getNormal(p);
            l = normalize(pLamp - p);
			vec3 h = normalize(l - rd);
            float diff = max(dot(n,l),0.);
            float fres = pow(1. - max(dot(n,-rd),0.), 5.);
            float spec = max(dot(n,h),0.);
        	//spec = pow(spec,4.);
            float q = atan(p.y, p.x); // polar coords
                
            //q /= tau;
            q *= 1.;
            
            if (d.y == 0. || d.y == 1.){
                vec3 tex;
                if (d.y == 0.){
                	tex = tex3D(texture1, p*0.7,n).xyz;
                } else {
                    p.xy *= rot(p.z*0.2);
                	tex = tex3D(texture2, p*5.,n).xyz;
                    tex = pow(tex, vec3(0.7));
                    tex.gb *= 1.2;
                    tex *= 0.1;
                }
                n.z += pow(tex.x*1.6, 4.)*0.2;
                diff = max(dot(n,l),0.);
                fres = pow(1. - max(dot(n,-rd),0.), 2.);
                spec = max(dot(n,h),0.);
                spec = pow(spec, 2.);
                col += mix(tex*diff*colLight*fres,tex*fres*spec*colLight,0.8 - length(tex.rg)*0.8) * (att);
                
            } else if (d.y == 2. || d.y == 3.){
            	//col += fres*diff;
                //col += diff;
            	//col += mix(diff,fres*spec,0.9) * (att);
                col = colLight*pow(1. , 2.)*att;
            } else if (d.y == 4.){
                vec3 tex = tex3D(texture1, p*0.7,n).xyz;
                
                tex.x *= 1.;
                tex.y *= 0.54;
                tex.z *= 0.4;
                tex.x = tex.y;
            	
            	col += mix(tex*diff*colLight,tex*fres*spec*colLight,0.1 + min(tex.r*1., 1.)) * (att);
            } else if (d.y == 5.){
                //vec3 tex = texture(ichanne, -n).xyz;
                vec3 tex = tex3D(texture1, p*0.7,n).xyz;
                
                tex.x *= 1.;
                tex.y *= 1.;
                tex.z *= 1.;
                tex.x = tex.y;
                tex.y = tex.x;
            	
                col += mix(tex*diff*colLight,tex*fres*pow(spec, 1.5)*colLight,0.9) *att;
            	//col += * (att);
            
            }
            
            
        	break;
        }
        
        t += d.x;
        p = ro + rd*t;
    }
    
    float shad = calcSoftshadow(p, l, 0.01, 100., 0 );
    col *= shad*att;
	
    
    col *= 4.;
    //col *= 3.;
    
    col += glow*0.004*colLight;
    //col -= glow*0.5*colLight*(1. - att);
    
    col = pow(col, vec3(0.45));
    col *= 1.5;
    //col = smoothstep(0.,0.6,col);
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

